/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Couleur;
import cds.aladin.Grid;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGRgb;
import cds.aladin.PlanContour;
import cds.aladin.PlanFolder;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageHuge;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanMoc;
import cds.aladin.PlanMultiCCD;
import cds.aladin.Select;
import cds.aladin.Tok;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public final class Slide {
    static final int gapL = 16;
    static final int DX = 33;
    static int DY;
    static final int DFOLDER = 10;
    static final int VIDE = 0;
    static final int GRIS = 1;
    static final int NOIR = 2;
    static final int DRAG = 3;
    static Color orange;
    static Color vert;
    static Color jauneGris;
    static Color grisfonce;
    static final int[] frX;
    static final int[] frY;
    static final int frMin;
    static final int frMax;
    static final int m;
    static final int xLabel;
    static final int[] t1x;
    static final int[] t1y;
    static final int[] t2x;
    static final int[] t2y;
    static final int[] i1y;
    static final int[] i1x;
    static final int[] i1l;
    static final int[] i2y;
    static final int[] i2x;
    static final int[] i2l;
    static final int[] trX;
    static final int[] trY;
    Vector slides = null;
    Plan p;
    Aladin a;
    int x1;
    int y1;
    int x2;
    int y2;
    Plan planRGB = null;
    protected int mode = 1;
    static final int OFF = 0;
    static final int ON = 1;
    static final int FILTER = 2;
    static final int EP = 4;
    static boolean blinkState;
    private int[] xc = null;
    private int[] yc = null;

    protected Slide(Aladin aladin, Plan plan) {
        this.p = plan;
        this.a = aladin;
        float x = aladin.getUIScale();
        DY = Math.round(19.0f * x * ((double)x > 1.2 ? 0.85f : 1.0f));
    }

    protected Plan getPlan() {
        return this.p;
    }

    protected boolean inBall(int x) {
        if (this.p.collapse) {
            return false;
        }
        return x > Select.ws - 12;
    }

    protected boolean inCheck(int x) {
        if (this.p.collapse) {
            return false;
        }
        return x < 16;
    }

    protected boolean inLogo(int x) {
        if (this.p.collapse) {
            return false;
        }
        return this.x1 <= x && x <= this.x2;
    }

    protected boolean inLabel(int x) {
        if (this.p.collapse) {
            return false;
        }
        return x > this.x2;
    }

    protected boolean inLogoCheck(int x) {
        if (this.p.collapse) {
            return false;
        }
        return x <= 16 || this.inLogo(x);
    }

    protected boolean in(int y) {
        if (this.p.collapse) {
            return false;
        }
        return this.y1 < y && y <= this.y2 + 1;
    }

    protected boolean sous(int y) {
        if (this.p.collapse) {
            return false;
        }
        return this.y2 - 10 <= y && y <= this.y2 + 5;
    }

    static void fillLogo(Graphics g, int[] x, int[] y, double pourcent, Color c) {
        double p = pourcent / 100.0;
        int Y = y[1] - 2 - (int)((double)(y[1] - y[0] - 4) * p);
        int X1 = x[1] + (int)((double)(x[0] - x[1]) * p);
        int X2 = x[2] - (int)((double)(x[2] - x[3]) * p);
        x[0] = x[4] = X1;
        x[3] = X2;
        y[3] = y[4] = Y;
        y[0] = y[4];
        g.setColor(c);
        g.fillPolygon(x, y, x.length);
    }

    static int fillTransparency(Graphics g, int[] x, int[] y, float transp, boolean flagDraw, Color c) {
        int X;
        double p = transp;
        g.setColor(c);
        if (p < 0.2) {
            int Y = y[0] + (int)((double)(y[1] - y[0]) * (1.0 - (p *= 5.0)));
            x[2] = x[3] = (X = x[1] + (int)((double)(x[0] - x[1]) * p) + 1);
            x[0] = x[3];
            y[0] = y[3] = Y;
        } else if (p < 0.8) {
            p = (p - 0.2) / 0.6;
            x[2] = x[3] = (X = x[0] + (int)((double)(x[3] - x[0]) * p));
        } else {
            p = (p - 0.8) / 0.2;
            int Y = y[3] + (int)((double)(y[2] - y[3]) * p);
            X = x[3] + (int)((double)(x[2] - x[3]) * p) + 1;
            x[4] = x[3];
            x[2] = x[3] = X;
            y[4] = y[3];
            y[3] = Y;
        }
        if (flagDraw) {
            g.fillPolygon(x, y, x.length);
        }
        return X;
    }

    static void drawLogoTool(Graphics g, int dx, int dy) {
        Slide.drawLogoTool(g, dx, dy, orange);
    }

    static void drawLogoTool(Graphics g, int dx, int dy, Color c) {
        int i;
        int[] y1 = new int[t1y.length];
        int[] y2 = new int[t2y.length];
        int[] x1 = new int[t1x.length];
        int[] x2 = new int[t2x.length];
        for (i = 0; i < y1.length; ++i) {
            y1[i] = t1y[i] + dy;
        }
        for (i = 0; i < y2.length; ++i) {
            y2[i] = t2y[i] + dy;
        }
        for (i = 0; i < x1.length; ++i) {
            x1[i] = t1x[i] + dx;
        }
        for (i = 0; i < x2.length; ++i) {
            x2[i] = t2x[i] + dx;
        }
        g.setColor(c);
        g.fillPolygon(x1, y1, y1.length);
        g.fillPolygon(x2, y2, y2.length);
        g.drawLine(x1[0], y1[0], x2[1], y2[1]);
    }

    static void drawLogoCat(Graphics g, int dx, int dy) {
        Slide.drawLogoCat(g, dx, dy, vert);
    }

    static void drawLogoCat(Graphics g, int dx, int dy, Color c) {
        int L = 8;
        g.setColor(c);
        int x = 32 + dx;
        for (int i = 0; i < 5; ++i) {
            int h = 4 + dy + i * 2;
            g.drawLine(x - L - i, h, x - 5 - i, h);
            g.drawLine(x - 2 - i, h, x, h);
            g.drawLine(x + 3, h, x + 5 + i, h);
            g.drawLine(x + 8 + i, h, x + L + 1 + i, h);
        }
    }

    static void drawLogoFilter(Graphics g, int dx, int dy, boolean active, boolean button, Color c, Color bord) {
        int i;
        int L = 33;
        int H = frY[1] - frY[0];
        int deb = -3;
        int fin = 3;
        int x1 = L / 2 - 5;
        int x2 = L / 2 - 6;
        g.setColor(c);
        int x = (button ? -2 : 16) + 16 + dx;
        if (button) {
            deb = -2;
            fin = 2;
        }
        for (i = 0; i < 4; ++i) {
            int h = 4 + dy + i * 2;
            g.drawLine(x - x1 - i, h, x + x2 + i, h);
        }
        for (i = deb; i <= fin; ++i) {
            g.drawLine(x + i * 3, 2 + dy, x + i * 5, dy + H);
        }
        g.setColor(bord);
        for (i = 0; i < 4; ++i) {
            int[] bx = new int[5];
            int[] by = new int[5];
            switch (i) {
                case 0: {
                    bx[1] = bx[4] = frX[0] - 16;
                    bx[0] = bx[4];
                    bx[2] = bx[3] = frX[3] - 16 - 33 + L;
                    by[3] = by[4] = frY[0];
                    by[0] = by[4];
                    by[1] = by[2] = frY[0] - 4 + 2;
                    break;
                }
                case 1: {
                    bx[3] = bx[4] = frX[0] - 16;
                    bx[0] = bx[4];
                    bx[1] = bx[2] = frX[1] - 16;
                    by[0] = by[4] = frY[0];
                    by[3] = frY[0] - 4 + 2;
                    by[1] = frY[0] + H;
                    by[2] = frY[0] + H - 4;
                    break;
                }
                case 2: {
                    bx[3] = bx[4] = frX[3] - 16 - 33 + L;
                    bx[0] = bx[4];
                    bx[1] = bx[2] = frX[2] - 16 - 33 + L;
                    by[0] = by[4] = frY[3];
                    by[3] = frY[3] - 4 + 2;
                    by[1] = frY[0] + H;
                    by[2] = frY[0] + H - 4;
                    break;
                }
                case 3: {
                    bx[1] = bx[4] = frX[1] - 16;
                    bx[0] = bx[4];
                    bx[2] = bx[3] = frX[2] - 16 - 33 + L;
                    by[3] = by[4] = frY[0] + H;
                    by[0] = by[4];
                    by[1] = by[2] = frY[0] + H - 4;
                }
            }
            int j = 0;
            while (j < bx.length) {
                int n = j;
                bx[n] = bx[n] + (dx + (!button ? 16 : 0));
                int n2 = j++;
                by[n2] = by[n2] + (dy + 2);
            }
            g.setColor(button ? bord : (!active ? Color.yellow : jauneGris));
            g.fillPolygon(bx, by, bx.length);
            g.setColor(!button ? Color.black : c);
            g.drawPolygon(bx, by, bx.length);
        }
    }

    private void drawClock(Graphics g, int dx, int dy, Color c, Color bg) {
        int x = dx + frX[2] - 27;
        int y = dy + frY[2] - 12;
        int r = 4;
        Slide.drawClock(g, x, y, r, c, bg);
    }

    public static void drawClock(Graphics g, int x, int y, int r, Color c, Color bg) {
        Color c1 = g.getColor();
        if (bg != null) {
            g.setColor(bg);
        }
        g.fillOval(x - r, y - r, 2 * r, 2 * r);
        if (c != null) {
            g.setColor(c);
        }
        g.drawOval(x - r, y - r, 2 * r, 2 * r);
        g.drawLine(x, y, x, y - r + 2);
        g.drawLine(x, y, x + r - 3, y);
        g.setColor(c1);
    }

    static void drawLogoImg(Graphics g, int dx, int dy, Color c) {
        int i;
        if (c != null) {
            g.setColor(c);
        }
        for (i = 0; i < i1x.length; ++i) {
            if (c == null) {
                int j = i * 3 / i1x.length;
                g.setColor(j == 0 ? Color.red : (j == 1 ? Color.blue : Color.green));
            }
            g.drawLine(i1x[i] + dx + 16, i1y[i] + dy, i1x[i] + i1l[i] + dx - 1 + 16, i1y[i] + dy);
        }
        g.setColor(c != null ? c : Color.black);
        for (i = 0; i < i2x.length; ++i) {
            g.drawLine(i2x[i] + dx + 16, i2y[i] + dy, i2x[i] + i2l[i] + dx - 1 + 16, i2y[i] + dy);
        }
    }

    static void drawLogoImgHuge(Graphics g, int dx, int dy, Color c) {
        Slide.drawLogoImg(g, dx, dy, c);
        g.setColor(Color.yellow);
        g.drawRect(dx + frX[2] - 15, dy + frY[2] - 8, 5, 5);
    }

    static void drawLogoTMOC(Graphics g, int dx, int dy, Color c) {
        int x = dx + frX[2] - 24;
        int y = dy + frY[2] - 9;
        int h = 5;
        g.setColor(c);
        g.drawRect(x, y, 1, h);
        g.drawRect(x += 3, y, 5, h);
        g.drawRect(x += 7, y, 2, h);
        g.drawRect(x += 5, y, 1, h);
    }

    static void drawLogoMOC(Graphics g, int dx, int dy, Color c) {
        int x = dx + 16 + 10;
        int y = dy + 3;
        Grid.fillMOC(g, x, y, Color.white);
        Grid.drawMOC(g, x, y, c);
    }

    static void drawLogoSED(Graphics g, int dx, int dy, Color c) {
        int x = dx + 16 + 8;
        int y = dy + 1;
        Grid.drawSED(g, x, y, c);
    }

    static void drawLogoImgBG(Graphics g, int dx, int dy, Color c) {
        int x = dx + 16 + 10;
        int y = dy + 3;
        Grid.fillBG(g, x, y, Color.white);
        Grid.drawGrid(g, x, y, c);
    }

    static void drawLogoPolarisation(Graphics g, int dx, int dy, Color c) {
        int x = dx + 16 + 10;
        int y = dy + 3;
        Grid.fillBG(g, x, y, Color.white);
        Grid.drawPolar(g, x, y, c);
    }

    protected static void drawLabel(Graphics g, String label, int x, int y, Color fg) {
        if (fg == null) {
            fg = Aladin.COLOR_FOREGROUND;
        }
        if (label.indexOf(47) < 0) {
            g.setColor(fg);
            g.drawString(label, x, y);
            return;
        }
        int lumin = fg.getBlue() + fg.getRed() + fg.getGreen();
        Color c = lumin > 255 ? fg.darker() : fg.brighter();
        Font f = g.getFont();
        Font f1 = f.deriveFont(f.getSize2D() - 1.0f);
        Tok tok = new Tok(label, "/");
        int w = 0;
        int i = 1;
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            boolean flagLow = i == 1 || (s.equals("P") || s.equals("C")) && i == 2;
            g.setFont(flagLow ? f1 : f);
            FontMetrics fm = g.getFontMetrics();
            w = fm.stringWidth(s);
            g.setColor(flagLow ? c : fg);
            g.drawString(s, x, y);
            x += w + 2;
            ++i;
            if (!tok.hasMoreTokens()) continue;
            g.setFont(f1);
            g.setColor(c);
            g.drawString("/", x, y);
            x += fm.stringWidth("/") + 2;
        }
        g.setFont(f);
    }

    protected static void drawBlink(Graphics g, int x, int y) {
        Slide.drawBlink(g, x, y, Color.green, Color.white);
    }

    protected static void drawBlink(Graphics g, int x, int y, Color c1, Color c2) {
        Slide.drawBall(g, x, y, blinkState ? c1 : c2);
    }

    synchronized void setBlink(boolean f) {
        this.a.calque.select.setSlideBlink(f);
    }

    protected static void drawFolderExt(Graphics g, int ext, int dx, int dy, Color c) {
        g.setColor(c);
        int x = dx + (frMin + frMax) / 2 + 1;
        int y = dy + 12;
        String s = ext + "";
        g.drawString(s, x -= g.getFontMetrics().stringWidth(s) / 2, y);
    }

    protected static void drawProportion(Graphics g, int x, int y, int width, int pourcent, Color c) {
        int w = (int)((double)pourcent / 100.0 * (double)width);
        g.setColor(c);
        g.drawLine(x, y + 2, x + width, y + 2);
        g.drawLine(x, y + 3, x + width, y + 3);
        g.setColor(Color.green);
        g.drawLine(x, y + 2, x + w, y + 2);
        g.drawLine(x, y + 3, x + w, y + 3);
        g.setColor(Color.gray);
        g.drawRect(x, y + 1, width, 3);
    }

    protected static void drawBall(Graphics g, int x, int y, Color c) {
        g.setColor(c);
        Util.fillCircle8(g, x += 4, y += 3);
        g.setColor(Color.black);
        Util.drawCircle8(g, x, y);
        g.setColor(Color.white);
        g.fillRect(x - 1, y - 1, 2, 2);
    }

    protected static void drawCross(Graphics g, int x, int y) {
        Slide.drawBall(g, x, y, Color.white);
        g.setColor(Color.red);
        int W = 10;
        g.drawLine(--x, y -= 2, x + W, y + W);
        g.drawLine(x, y + 1, x + W, y + W + 1);
        g.drawLine(x, y + W, x + W, y);
        g.drawLine(x, y + W + 1, x + W, y + 1);
    }

    protected void redraw(Graphics g, int xMouse, int yMouse, int dx, int dy) {
        try {
            boolean inLabel;
            boolean flagMouseIn;
            int i;
            Color labelBG = this.a.calque.select.getBackground();
            Color colorForeground = this.p.c;
            Color colorBorder = Aladin.COLOR_CONTROL_FOREGROUND;
            Color colorFillFG = Aladin.MYGRAY;
            Color colorFillBG = Color.white;
            if (this.p.collapse) {
                return;
            }
            if (this.xc == null) {
                this.yc = new int[frX.length];
                this.xc = new int[frX.length];
            }
            g.setFont(Aladin.PLAIN);
            int ht = Math.round(Aladin.PLAIN.getSize2D());
            if (this.planRGB != null) {
                boolean flagInv;
                boolean bl = flagInv = ((PlanImage)this.planRGB).video == 1;
                if (this.p.hashCode() == ((PlanImageRGB)this.planRGB).pi[0]) {
                    colorForeground = flagInv ? Color.cyan : Color.red;
                } else if (this.p.hashCode() == ((PlanImageRGB)this.planRGB).pi[2]) {
                    colorForeground = flagInv ? Color.yellow : Color.blue;
                } else if (this.p.hashCode() == ((PlanImageRGB)this.planRGB).pi[1]) {
                    colorForeground = flagInv ? Color.magenta : Color.green;
                }
            }
            boolean ref = xMouse <= 0 && this.p.type != 0 && this.p.underMouse && this.a.view.isVisible(this.p) && this.a.view.isMultiView();
            for (i = 0; i < frX.length; ++i) {
                this.yc[i] = frY[i] + dy;
            }
            for (i = 0; i < frX.length; ++i) {
                this.xc[i] = frX[i] + dx;
            }
            int y = Math.round((float)dy - (1.0f + (Aladin.getUIScale() - 1.0f) * 10.0f));
            int x = dx + xLabel - 1;
            int H = ht + 7;
            int W = Select.ws - x;
            boolean bl = flagMouseIn = this.in(yMouse) && this.inLabel(xMouse);
            if (this.mode != 3 && (ref || this.p.selected || this.p.isHighlighted || this.p.type != 0 && flagMouseIn)) {
                labelBG = this.p.selected ? Aladin.COLOR_STACK_SELECT : Aladin.COLOR_STACK_HIGHLIGHT;
                g.setColor(labelBG.brighter());
                g.fillRect(x, y, W, H - 2);
                g.setColor(labelBG);
                g.drawRect(x, y, W - 1, H - 2);
            } else if (this.mode != 3) {
                g.setColor(labelBG);
                g.fillRect(x, y, W, H - 2);
            }
            boolean isRefForVisibleView = this.p.isRefForVisibleView();
            if (isRefForVisibleView) {
                colorFillFG = Color.gray;
            }
            boolean canBeTransparent = this.a.calque.canBeTransparent(this.p);
            boolean isViewable = this.p.isViewable();
            boolean inLogo = this.inLogo(xMouse) && this.in(yMouse);
            boolean bl2 = inLabel = this.inLabel(xMouse) && this.in(yMouse);
            if (inLogo && isRefForVisibleView) {
                this.xc[0] = this.xc[0] - 1;
                this.yc[0] = this.yc[0] - 1;
                this.xc[4] = this.xc[4] - 1;
                this.yc[4] = this.yc[4] - 1;
                this.xc[3] = this.xc[3] + 1;
                this.yc[3] = this.yc[3] - 1;
                this.xc[1] = this.xc[1] - 1;
                this.yc[1] = this.yc[1] + 1;
                this.xc[2] = this.xc[2] + 1;
                this.yc[2] = this.yc[2] + 1;
            }
            int xPoignee = frMin + dx;
            if ((this.p.isImage() || this.p.type == 9 && this.p instanceof PlanContour || this.p instanceof PlanBG) && this.p.error == null && !this.p.flagOk) {
                double pourcent = this.p.getPourcent();
                g.setColor(colorFillBG);
                g.fillPolygon(this.xc, this.yc, frX.length);
                Slide.fillLogo(g, this.xc, this.yc, pourcent, colorFillFG);
            } else {
                float transp;
                if (this.p.type == 11) {
                    this.adjustFolderState((PlanFolder)this.p);
                    g.setColor(!this.p.active || canBeTransparent ? Color.yellow : jauneGris);
                } else if (isRefForVisibleView && this.p.isUnderImgBkgd() && this.p.type != 16) {
                    g.setColor(colorFillBG);
                } else {
                    g.setColor(!this.p.active || !isRefForVisibleView && isViewable && canBeTransparent ? colorFillBG : colorFillFG);
                }
                g.fillPolygon(this.xc, this.yc, frX.length);
                if (canBeTransparent && (transp = this.p.getOpacityLevel()) != 0.0f) {
                    xPoignee = Slide.fillTransparency(g, this.xc, this.yc, transp, this.p.active, this.p.type == 11 ? jauneGris : colorFillFG);
                }
            }
            g.setColor(colorBorder);
            g.drawPolygon(this.xc, this.yc, frX.length);
            g.drawLine(this.xc[1], this.yc[1], this.xc[2], this.yc[2]);
            if (this.p.type == 11) {
                int[] xf = new int[5];
                int[] yf = new int[5];
                xf[0] = xf[4] = this.xc[1];
                yf[4] = yf[3] = this.yc[1];
                yf[0] = yf[3];
                xf[1] = this.xc[1] + 3;
                yf[1] = yf[2] = this.yc[1] + 3;
                xf[2] = this.xc[1] + 15;
                xf[3] = this.xc[1] + 18;
                if (!this.a.calque.isCollapsed(this.p)) {
                    g.drawLine(this.xc[2] - 2, this.yc[1] + 1, this.xc[2] - 2, this.yc[1] + 1);
                    g.drawLine(this.xc[1] + 2, this.yc[1] + 2, this.xc[2] - 1, this.yc[1] + 2);
                } else {
                    g.drawLine(this.xc[1], this.yc[1] + 1, this.xc[2], this.yc[1] + 1);
                    g.drawLine(this.xc[1], this.yc[1] + 2, this.xc[2], this.yc[1] + 2);
                }
                if (((PlanFolder)this.p).localScope) {
                    int a = (this.xc[0] + this.xc[3]) / 2;
                    int b = (this.yc[0] + this.yc[1]) / 2 + 1;
                    g.drawLine(this.xc[0], this.yc[0], a, b);
                    g.drawLine(a, b, this.xc[3], this.yc[3]);
                    g.drawLine(this.xc[1], this.yc[1], a - 2, b - 1);
                    g.drawLine(a + 2, b - 1, this.xc[2], this.yc[2]);
                }
                g.setColor(Color.yellow);
                g.fillPolygon(xf, yf, xf.length);
                g.setColor(colorBorder);
                g.drawPolygon(xf, yf, xf.length);
            } else if (this.p.isCube()) {
                g.drawLine(this.xc[1] + 1, this.yc[1] + 1, this.xc[1] + 1, this.yc[1] + 1);
                g.drawLine(this.xc[2] - 2, this.yc[1] + 1, this.xc[2] - 2, this.yc[1] + 1);
                g.drawLine(this.xc[1], this.yc[1] + 2, this.xc[2] - 1, this.yc[1] + 2);
            } else {
                g.drawLine(this.xc[1], this.yc[1] + 1, this.xc[2], this.yc[1] + 1);
            }
            Color c = Color.black;
            if (this.p instanceof PlanBG && ((PlanBG)this.p).hasRecutListener()) {
                PlanBGRgb p1 = ((PlanBG)this.p).getRecutListener();
                c = p1.red == this.p ? Color.red : (p1.green == this.p ? Color.GREEN : Color.blue);
            }
            switch (this.p.type) {
                case 1: 
                case 5: 
                case 7: {
                    Slide.drawLogoImg(g, dx, dy, colorForeground);
                    break;
                }
                case 2: 
                case 20: {
                    Slide.drawLogoImg(g, dx, dy, null);
                    break;
                }
                case 15: {
                    Slide.drawLogoImgHuge(g, dx, dy, colorForeground);
                    break;
                }
                case 23: {
                    Slide.drawLogoTMOC(g, dx, dy, isViewable ? this.p.c : colorFillFG);
                    break;
                }
                case 19: 
                case 24: {
                    Slide.drawLogoMOC(g, dx, dy, isViewable ? this.p.c : colorFillFG);
                    break;
                }
                case 18: {
                    Slide.drawLogoImgBG(g, dx, dy, isViewable ? this.p.c : colorFillFG);
                    break;
                }
                case 16: {
                    Slide.drawLogoImgBG(g, dx, dy, isViewable ? c : colorFillFG);
                    break;
                }
                case 17: {
                    Slide.drawLogoPolarisation(g, dx, dy, isViewable ? this.p.c : colorFillFG);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    Slide.drawLogoImg(g, dx, dy, Color.black);
                    break;
                }
                case 9: 
                case 10: {
                    if (this.p.isCatalog()) {
                        Slide.drawLogoCat(g, dx, dy, colorForeground);
                    }
                    Slide.drawLogoTool(g, dx, dy, colorForeground);
                    break;
                }
                case 8: {
                    if (this.p.isSED()) {
                        Slide.drawLogoSED(g, dx, dy, colorForeground);
                        break;
                    }
                    Slide.drawLogoCat(g, dx, dy, colorForeground);
                    break;
                }
                case 12: {
                    Slide.drawLogoFilter(g, dx, dy, this.p.active, false, Color.black, Color.black);
                }
            }
            if (this.p instanceof PlanMultiCCD) {
                Slide.drawFolderExt(g, ((PlanMultiCCD)this.p).getSize(), dx, dy, Color.yellow);
            }
            if (this.p.isTime()) {
                this.drawClock(g, dx, dy, Color.black, Color.white);
            }
            this.drawCheckBox(g, 3, dy + 3, xMouse, yMouse, this.mode, this.p);
            if (this.mode != 3 && this.p.folder > 0) {
                Plan[] allPlan = this.a.calque.getPlans();
                int n = this.a.calque.getIndex(allPlan, this.p);
                g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
                for (int i2 = 0; i2 < this.p.folder; ++i2) {
                    boolean last = i2 == this.p.folder - 1;
                    boolean trouve = false;
                    for (int j = n + 1; j < allPlan.length && allPlan[j].folder != i2; ++j) {
                        if (allPlan[j].folder != i2 + 1) continue;
                        trouve = true;
                        break;
                    }
                    if (!trouve && !last) continue;
                    boolean demi = !trouve && last && (n == allPlan.length - 1 || allPlan[n + 1].folder != this.p.folder);
                    x = 6 + (i2 + 1) * 10;
                    g.drawLine(x + 5, dy, x + 5, dy + (demi ? DY / 2 : DY));
                    if (!last) continue;
                    g.drawLine(x + 5, dy + DY / 2, x + 12, dy + DY / 2);
                }
            }
            if (this.p.label != null) {
                int px;
                int py = dy + 15 - 1;
                int px1 = px = Select.ws - 12;
                x = dx + xLabel;
                Color fg = this.p.c;
                try {
                    if ((labelBG == Aladin.COLOR_STACK_HIGHLIGHT || labelBG == Aladin.COLOR_STACK_SELECT) && this.p.c.equals(Couleur.DC[2])) {
                        fg = Aladin.COLOR_GREEN;
                    } else if (Aladin.DARK_THEME && labelBG == Aladin.COLOR_STACK_SELECT && this.p.c.equals(Couleur.DC[1])) {
                        fg = Color.black;
                    } else if (labelBG == Aladin.COLOR_STACK_SELECT && (this.p.c.equals(Couleur.DC[7]) || this.p.c.equals(Couleur.DC[8])) || this.p.c.equals(Color.black)) {
                        fg = Aladin.COLOR_CONTROL_FOREGROUND;
                    } else if (this.p.c == null || this.p.c.equals(Color.black)) {
                        fg = Aladin.COLOR_CONTROL_FOREGROUND;
                    }
                    if (inLabel) {
                        fg = fg.brighter();
                    }
                }
                catch (Exception trouve) {
                    // empty catch block
                }
                Slide.drawLabel(g, this.p.getLabel(), x, py - 1, fg);
                if (this.mode != 3) {
                    this.p.status = 0;
                    if (this.p.type == 11 && !this.p.isSync()) {
                        Slide.drawBlink(g, px, py - 9);
                        this.setBlink(true);
                        this.p.status |= 1;
                        if (this.p.pourcent > 0.0) {
                            Slide.drawFolderExt(g, (int)this.p.pourcent, 0, dy, Color.gray);
                        }
                    } else if (this.p.isSimpleCatalog() || this.p.isImage() || this.p instanceof PlanContour || this.p.type == 12 || this.p instanceof PlanBG) {
                        if (this.p.error != null) {
                            boolean hasObj;
                            boolean bl3 = hasObj = this.p.pcat != null && this.p.pcat.hasObj();
                            if (this.p.hasNoPos) {
                                Slide.drawBall(g, px, py - 9, Aladin.ORANGE);
                                this.p.status |= 0x200;
                            } else if (this.p.hasNoReduction() && (!this.p.isSimpleCatalog() || hasObj)) {
                                Slide.drawBall(g, px, py - 9, Aladin.ORANGE);
                                this.p.status |= 0x20;
                            } else if (this.p.isSimpleCatalog() && this.p.error.indexOf("OVERFLOW") >= 0) {
                                Slide.drawBall(g, px, py - 9, Aladin.ORANGE);
                                this.p.status |= 0x10;
                            } else if (this.p.isSimpleCatalog() && this.p.error != null && !this.p.error.startsWith("EMPTY")) {
                                Slide.drawBall(g, px1, py - 9, Color.red);
                                this.p.status |= 4;
                            } else if (this.p.isSimpleCatalog() && !hasObj) {
                                Slide.drawCross(g, px1, py - 9);
                                this.p.status |= 0x40;
                            } else {
                                Slide.drawBall(g, px1, py - 9, Color.red);
                                this.p.status |= 4;
                            }
                        } else {
                            Color green;
                            boolean flag = false;
                            if (this.p instanceof PlanBG && ((PlanBG)this.p).hasMoreDetails()) {
                                green = Aladin.LIGHTORANGE;
                                this.p.status |= 2;
                            } else {
                                green = Color.green;
                            }
                            if (!this.p.flagOk || this.p instanceof PlanContour && ((PlanContour)this.p).mustAdjustContour || (flag = this.p.flagProcessing || this.p.type == 15 && ((PlanImageHuge)this.p).isExtracting || this.p instanceof PlanBG && ((PlanBG)this.p).isLoading())) {
                                this.p.status |= 0x80;
                                if (flag) {
                                    Slide.drawBlink(g, px, py - 9, Color.white, green);
                                } else {
                                    Slide.drawBlink(g, px1, py - 9);
                                }
                                this.setBlink(true);
                            } else if (this.p instanceof PlanBG) {
                                if (this.p.isMoc() && ((PlanMoc)this.p).getMoc().isEmpty()) {
                                    Slide.drawCross(g, px1, py - 9);
                                    this.p.status |= 8;
                                } else if (this.p.active) {
                                    Slide.drawBall(g, px, py - 9, green);
                                }
                            }
                            if (this.p.getCompletude() >= 0.0 && this.p.active) {
                                int w = 45;
                                Slide.drawProportion(g, px - w, py - 1, w, (int)this.p.getCompletude(), green);
                            }
                        }
                    }
                }
            }
            if (this.mode != 3 && canBeTransparent) {
                float transp;
                int largeur = 3;
                int debut = frX[1];
                int fin = frX[2];
                int haut = frY[1];
                int xPos = xPoignee;
                if (xPos < dx + debut + largeur) {
                    xPos = dx + debut + largeur;
                }
                if (xPos > dx + fin - largeur) {
                    xPos = dx + fin - largeur;
                }
                if (this.p.type != 11) {
                    g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
                    g.drawLine(dx + debut, dy + haut, dx + fin, dy + haut);
                    g.drawLine(dx + debut, dy + haut + 1, dx + fin, dy + haut + 1);
                }
                g.setColor((double)(transp = this.p.getOpacityLevel()) <= 0.1 ? Color.red : Color.green);
                g.fillRect(xPos - 1, dy + haut - largeur, largeur, largeur * 2 + 1);
                g.setColor(Color.black);
                g.drawRect(xPos - 1, dy + haut - largeur, largeur, largeur * 2 + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void adjustFolderState(PlanFolder f) {
        boolean active = f.active;
        boolean allNotActive = true;
        for (Plan p : this.a.calque.getFolderPlan(f)) {
            if (!active && p.active) {
                f.active = true;
                return;
            }
            allNotActive &= !p.active;
        }
        if (active && allNotActive) {
            f.active = false;
        }
    }

    private void drawCheckBox(Graphics g, int x, int y, int xMouse, int yMouse, int mode, Plan p) {
        p.setHasCheckBox(false);
        if (!p.isReady()) {
            return;
        }
        if (p.type == 11) {
            return;
        }
        if (mode == 3) {
            return;
        }
        if (!p.shouldHaveARefCheckBox()) {
            return;
        }
        if (p.isCheckBoxBlink()) {
            Util.drawCheckbox(g, x, y, Color.gray, this.inCheck(xMouse) && this.in(yMouse) ? Aladin.BLUE : null, Color.red, blinkState);
            this.setBlink(true);
        } else {
            Util.drawCheckbox(g, x, y, Color.gray, this.inCheck(xMouse) && this.in(yMouse) ? Aladin.BLUE : null, Color.black, p.isRefForVisibleView());
        }
        p.setHasCheckBox(true);
    }

    protected void dragDraw(Graphics g, int x, int y) {
        this.mode = 3;
        this.redraw(g, -1, -1, x - 16 - 16, y - DY / 2);
    }

    protected void redraw(Graphics g, int xMouse, int yMouse) {
        this.redraw(g, xMouse, yMouse, this.x1 - 16, this.y1);
    }

    protected int draw(Graphics g, int dy, int xMouse, int yMouse, Plan planRGB, int mode) {
        if (this.p.collapse) {
            return dy;
        }
        int dx = this.p.folder * 10;
        this.x1 = 16 + dx;
        this.x2 = frMax + 4 + dx;
        this.y1 = dy;
        this.y2 = dy + DY;
        this.planRGB = planRGB;
        this.mode = mode;
        this.redraw(g, xMouse, yMouse, dx, dy);
        return dy -= DY;
    }

    static {
        orange = new Color(255, 102, 0);
        vert = new Color(0, 187, 0);
        jauneGris = new Color(181, 181, 49);
        grisfonce = new Color(90, 90, 90);
        frX = Select.frX;
        frY = Select.frY;
        frMin = Select.frMin;
        frMax = Select.frMax;
        m = Select.MILIEU;
        xLabel = frMax + 4;
        t1x = new int[]{16, 22, 31, 16};
        t1y = new int[]{12, 7, 10, 12};
        t2x = new int[]{33, 42, 40, 33};
        t2y = new int[]{3, 2, 6, 4};
        i1y = new int[]{4, 3, 2, 3, 4, 5, 6, 7, 8, 9, 8, 7, 6, 5, 6, 7, 8, 9, 10, 11, 12, 11, 10};
        i1x = new int[]{28, 26, 17, 14, 12, 11, 10, 10, 11, 12, 15, 14, 14, 16, 21, 22, 22, 21, 19, 15, 8, 6, 5};
        i1l = new int[]{1, 2, 9, 5, 3, 2, 2, 2, 2, 6, 5, 6, 5, 6, 2, 2, 2, 2, 3, 5, 9, 2, 1};
        i2y = new int[]{3, 6, 10, 11, 11, 12};
        i2x = new int[]{9, 26, 27, 4, 26, 27};
        i2l = new int[]{1, 1, 1, 1, 3, 1};
        trX = new int[]{4, 4, 12, 4};
        trY = new int[]{0, 16, 8, 0};
        blinkState = true;
    }
}

